<?php

class USIN_Woocommerce_Sales_Loader extends USIN_Period_Report_Loader {
	protected $statuses;

	protected function load_data(){
		global $wpdb;
		$this->statuses = USIN_Woocommerce_Query::get_sales_statuses(true);
		$query = USIN_Woocommerce::custom_order_tables_enabled() ? $this->get_query() : $this->get_legacy_query();

		return $wpdb->get_results($query);
	}

	protected function get_query(){
		global $wpdb;
		$date_select = USIN_Query_Helper::get_gmt_offset_date_select('date_created_gmt');

		return $wpdb->prepare("SELECT COUNT(*) AS $this->total_col, $date_select AS $this->label_col FROM {$wpdb->prefix}wc_orders AS orders" . $this->get_product_query() .
			" WHERE type = %s AND status IN ($this->statuses) AND $date_select >= %s AND $date_select <= %s GROUP BY {$this->get_group_by()}",
			USIN_Woocommerce::ORDER_POST_TYPE, $this->get_period_start(), $this->get_period_end());
	}

	protected function get_legacy_query(){
		global $wpdb;

		return $wpdb->prepare("SELECT COUNT(*) AS $this->total_col, post_date AS $this->label_col FROM $wpdb->posts AS orders" . $this->get_product_query() .
			" WHERE post_type = %s AND post_status IN ($this->statuses) AND post_date >= %s AND post_date <= %s GROUP BY {$this->get_group_by()}",
			USIN_Woocommerce::ORDER_POST_TYPE, $this->get_period_start(), $this->get_period_end());
	}

	protected function get_product_query(){
		global $wpdb;
		$product = $this->get_selected_group_filter('product');

		if(!$product){
			return '';
		}

		$id_column = USIN_Woocommerce::custom_order_tables_enabled() ? 'id' : 'ID';
		return $wpdb->prepare(" INNER JOIN {$wpdb->prefix}woocommerce_order_items AS items ON orders.{$id_column} = items.order_id" .
			" INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta AS meta ON items.order_item_id = meta.order_item_id" .
			" AND meta.meta_key = '_product_id' AND meta.meta_value = %d", $product);
	}
}